
;----------------------------------------------
; HORIZONTAL SCROLLER
; Eduardo A. Robsy Petrus [25/04/2005]
; (c) Karoshi Corporation, 2005
;----------------------------------------------
; - Core routine size: 86 bytes.
; - Full frame rate (50/60 Hz)
; - Supports any 8x8 type set
;----------------------------------------------
; PROs: Fast and compact.
; CONs: Only 8x8 fonts supported.
;----------------------------------------------


;----------------------------------------------
; PROGRAM CODE
;----------------------------------------------
hscroll_main:

		ei
		call npc_init

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; Vacia el buffer (256 bytes)

		ld hl,BUFFER
		xor a
		ld b,a
_CLEAR:
		ld (hl),a
		inc hl
		djnz _CLEAR

           
_RESTART:
		ld hl,TEXT ; comienzo del texto del scroll
_SCROLLER:
		ld de,BUFFER+32*8   ; guarda la dirección de la columna "32"
		ld a,(hl)           ; carga el siguiente caracter a imprimir
		inc hl
		cp 27               ; es el codigo ASCII 27
		jr z,_RESTART       ; si es cierto, reinicia el scroll
		push hl             ; si no lo es...
		ld l,a
		ld h,0
		add hl,hl
		add hl,hl
		add hl,hl
		ld bc,FONTS-'!'*8+116*8
		add hl,bc           ; ...calcula la posicion en la fuente de los datos del caracter...
		ld bc,8
		ldir                ; ...y los vuelca a la columna virtual que queda fuera de pantalla (la 32)
		
		ld b,8              ; repetiremos el scroll 8 veces hasta que un caracter haya sido desplazado fuera de pantalla
_SCROLL:
		push bc

		call	PT3_ROUT	; Write values on PSG registers
		call 	npc_loop
		call 	plot_enemy
	
		halt                ; sincroniza con el vblank
		call	_sat_update

_WAIT:
		ld de,256*8*2
		call vpoke         ; prepara para escritura el VDP al inicio de la ultima fila de caracteres 

		ld hl,BUFFER
		push hl
		ld c,98h
		ld b,0
_OUT_LOOP:
		outi
		jr  nz,_OUT_LOOP
;    otir                ; vuelca del buffer a la VRAM 256 bytes

;;;;;;;;;;;;;;;;;;;;;;;;;;;			
		call gest_keyb
		call testspace
		or a

		jp	z,startgame

;;;;;;;;;;;;;;;;;;;;;;;;;;
		ld      a,(vsf)
		and     a
		jp      nz,PAL		; if PAL call at any interrupt

NTSC:
		ld      hl,cnt      ; if NTSC call 5 times out of 6
		dec     (hl)
		jp      nz,PAL      ; skip one tic out of 6 when at 60hz

		ld      (hl),6      ; reset the tic counter
		jp	skip_audio      ; continue

PAL:                        ; execute the PSG and ayFX core
		call	PT3_PLAY	; Calculates PSG values for next frame
		call 	ayFX_FRAME

skip_audio:

		pop de              ; DE=BUFFER
		ld hl,BUFFER-8
		ld bc,256+8         ; repetimos tantas veces como bytes tenemos en el buffer
_SHIFT:
		ld a,(de)           ; cargamos un byte de un caracter
		sla a               ; lo desplazamos a la izquierda a traves del carry
		ld (de),a           ; y lo volvemos a dejar en su sitio
		ld a,0              ; ¡importante!, A debe ser 0 pero no podemos modificar el contenido del carry
		rla                 ; rotamos a la izquierda A a traves del carry, introducimos el bit que desplazamos anteriormente
		or (hl)             ; lo mezclamos con el byte que esta a su "izquierda"
		ld (hl),a           ; y lo dejamos tambien en su sitio
		inc hl              ; nos posicionamos en los siguientes caracteres
		inc de
		dec bc
		ld a,b
		or c                ; hemos acabado
		jr nz,_SHIFT        ; si no repetimos

		pop bc
		djnz _SCROLL        ; repetimos hasta sacar un caracter fuera de pantalla

		pop hl
		jp _SCROLLER



;----------------------------------------------
; SCROLLER TEXT
; Use ASCII code 27 (ESC) to define end
;----------------------------------------------
TEXT:
		db  "        Hello all MSX and Retro Fans ! "
		db	" Welcome back to the '80s for this ultimate retro-compilation of games originally "
		db	"released for Colecovision and Sega SG1000. Here you'll find 2 new KONAMI games, "
		db	"never released on MSX. And, it's our pleasure to finally bring to the MSX scene what Konami itself never did... "
		db	"Oh, and by the way, as this is an oldSkool compilation, made for, and by, oldSkool middle-aged fellas, we think that the traditional cracktro greetings are like an obligation... "
		db	"        3...        2...        1...        0...        ff...        "
		db	"--- Game Conversions  by Muffie (Brazil), Cartridge Menu by Artrag (Italy), menu picture and SFX by Toni Galvez (Spain),"
		db	"Game Selection code by Magoo (U.S.A.), Menu Music Player based on Shiru's AYFX Player (Russian Federation), "
		db	"Menu Music by John Hassink (Netherlands), Cartridge Manufacurer and provider Ericb59 (France). "
		db	"Our PRIME greetings go to Victor The Crazy and Guilherme-Toti for carrying on the MSX legacy, Rocha for the Chui Ticket, Edu-Exu for provigil support, "
		db	"Igor Douglas Nery Monteiro for giving away his honor, Hose Diogo Martinez for sharing his girlfriend with everyone who's brave enough, "
		db	"Linguinha for the inheritance, Slutywooman for releasing crappy conversions (otherwise this cart would never been possible), "
		db	"Irmandade dos 10 for playing vampiro coxador with Diego and finally to The Bits, Edutor, Scan Systems, Vector Design, Bau de Jogos, Ever Technology and BRX3. Now the SUB-PRIME greetings go to: Bifi, Huey, "
		db	"z80ST (thanks for your music player), Robsy Petrus, dvik (for the emulator that comes with the roms instead of just C-BIOS), Norakomi, "
		db	"Magoo, Wouter (for making us dig the internet for MSX ROMS), Grauw (for the marvelous technical database), Daemos, LordSMZett, "
		db	"NYYRIKKI, Edwin, Wolf, Jon Cortazar, Shiru (again!, thanks for your SFX code and editor) "
		db	"Very special greetings go to all msx village "
		db	"members, and specially to  Fabf, GuillianSeed, Jipe, MSXLegend. "
		db	"Also special thanks to DrFloyd from Gamopat and to Eugeny Brychkov "
		db	"for his V9938 online manual and his help                  "
		db	"almost forgot...      to travel into time just like Marty McFly, during boot try our ESCape plan at 88 miles per hour...     ","   ", 27


;----------------------------------------------
; VARIABLES
;----------------------------------------------
	    code @ 0C000h
BUFFER: ds 33*8 ; buffer con una fila completa de caracteres (32) mas 1
;----------------------------------------------

enemies:		[max_enem] enemy_data
ram_sat         ds 128
visible_sprts	ds	1
reverse_sat     ds  1

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	include AYFX-RAM.ASM
	include	PT3-RAM.ASM

freeram:		